<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'CrudController::index',  ['filter' => 'auth']);

$routes->group('crud', ['filter' => 'auth'], function ($routes) {
    $routes->get('generate/(:any)', 'GenerateController::generate/$1');

    $routes->get('(:segment)', 'CrudController::index/$1');
    $routes->get('listData/(:segment)', 'CrudController::listData/$1');
    $routes->get('form/(:segment)/(:segment)', 'CrudController::form/$1/$2');
    $routes->get('form/(:segment)', 'CrudController::form/$1');
    $routes->post('save/(:any)', 'CrudController::save/$1');
    $routes->post('import/(:segment)', 'CrudController::import/$1');
    $routes->get('export/(:segment)', 'CrudController::export/$1');
    $routes->post('delete/(:segment)/(:num)', 'CrudController::delete/$1/$2');
    $routes->get('loadTableContent/(:segment)', 'CrudController::loadTableContent/$1');
    //    $routes->post('loadTableContent/(:segment)', 'CrudController::loadTableContent/$1');
    $routes->post('saveData/(:segment)', 'CrudController::saveData/$1');
    $routes->get('getData/(:segment)/(:num)', 'CrudController::getData/$1/$2');
    $routes->get('getRow/(:any)/(:num)', 'CrudController::getRow/$1/$2');
    $routes->get('get/(:segment)/(:num)', 'CrudController::get/$1/$2');
    $routes->get('structure/(:segment)', 'CrudController::structure/$1');
    $routes->post('updateToggle', 'CrudController::updateToggle');
    $routes->post('deleteAll/(:segment)', 'CrudController::deleteAll/$1');

    // 🔹 Tambahkan route activeView di sini
    $routes->post('activeView/(:segment)', 'CrudController::activeView/$1');

    $routes->post('clearActiveView', 'CrudController::clearActiveView');
    //$routes->post('setActiveView/(:segment)', 'CrudController::activeView/$1');
    // $routes->post('clearActiveView', 'CrudController::clearActiveView');
    $routes->get('activeView', 'CrudController::loadActiveView');
    // simpan tabel terakhir diakses
    $routes->post('saveLastTable', 'CrudController::saveLastTable');
    $routes->post('setActiveViewSession', 'CrudController::setActiveViewSession');

    // $routes->post('setLastSidebarTableSession', 'CrudController::setLastSidebarTableSession');

    // 🔹 Route untuk penyimpanan dan pemulihan state ActiveView
    // $routes->post('saveViewState', 'CrudController::saveViewState');
    // $routes->get('getViewState', 'CrudController::getViewState');
    // $routes->get('getActiveViewStates', 'CrudController::getActiveViewStates');
});



$routes->get('/login', 'Auth::login');
$routes->post('/auth/doLogin', 'Auth::doLogin');

$routes->get('/register', 'Auth::register');
$routes->post('/auth/doRegister', 'Auth::doRegister');

$routes->get('/logout', 'Auth::logout');


$routes->group('updater', ['namespace' => 'App\Controllers'], function ($routes) {
    $routes->get('/', 'Updater::index');             // tampilan UI update
    $routes->get('check', 'Updater::check');         // cek versi terbaru
    $routes->post('apply', 'Updater::apply');        // update online
    $routes->post('applyOffline', 'Updater::applyOffline'); // update offline
});
$routes->get('updater/test_connection', 'Updater::testConnection');
