<?= $this->extend('layouts/main') ?>

<?= $this->section('sidebar') ?>

<?php
$session = session();

// 🔹 Fungsi helper untuk id aman
function slug_for_id($text, $fallbackIndex = 0)
{
    $slug = preg_replace('/[^a-z0-9]+/i', '-', trim($text));
    $slug = trim(strtolower($slug), '-');
    if ($slug === '') $slug = 'kategori-' . $fallbackIndex;
    return $slug;
}
?>

<!-- User info -->
<div class="p-3 border-bottom">
    <div class="d-flex align-items-center">
        <div class="flex-grow-1">
            <strong><?= esc($session->get('user_name')) ?></strong><br>
            <small class="text-muted"><?= esc($session->get('user_role')) ?></small>
        </div>
        <a href="<?= base_url('logout') ?>" class="btn btn-sm btn-outline-danger ms-2" title="Logout">
            <i class="fas fa-sign-out-alt"></i>
        </a>
    </div>
</div>

<!-- List tabel -->
<ul class="nav flex-column mt-3">
    <?php if (!empty($groupedTables)): ?>
        <?php $index = 0; ?>
        <?php foreach ($groupedTables as $kategori => $items): ?>
            <?php $safeId = 'collapse-' . slug_for_id($kategori, $index++); ?>

            <?php if ($kategori !== 'Tanpa Kategori'): ?>
                <li class="nav-item">
                    <a href="#<?= esc($safeId) ?>"
                        class="nav-link d-flex justify-content-between align-items-center"
                        data-toggle="collapse"
                        data-bs-toggle="collapse"
                        role="button"
                        aria-expanded="false"
                        aria-controls="<?= esc($safeId) ?>">
                        <span>
                            <i class="fas fa-folder mr-2 text-secondary"></i>
                            <?= ucfirst($kategori) ?>
                        </span>
                        <i class="fas fa-chevron-down small"></i>
                    </a>

                    <ul class="collapse list-unstyled pl-3" id="<?= esc($safeId) ?>">
                        <?php foreach ($items as $t): ?>
                            <?php
                            $key = strtolower($t);
                            $icon = isset($icons[$key]) && !empty($icons[$key]) ? $icons[$key] : 'fas fa-table';
                            ?>
                            <li class="nav-item">
                                <a href="#"
                                    class="nav-link table-link d-flex align-items-center <?= ($table ?? '') === $t ? 'active' : '' ?>"
                                    data-table="<?= esc($t) ?>">
                                    <i class="<?= esc($icon) ?> mr-2 text-secondary"></i>
                                    <span><?= ucfirst(esc($t)) ?></span>
                                </a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </li>

            <?php else: ?>
                <?php foreach ($items as $t): ?>
                    <?php
                    $key = strtolower($t);
                    $icon = isset($icons[$key]) && !empty($icons[$key]) ? $icons[$key] : 'fas fa-table';
                    ?>
                    <li class="nav-item">
                        <a href="#"
                            class="nav-link table-link d-flex align-items-center <?= ($table ?? '') === $t ? 'active' : '' ?>"
                            data-table="<?= esc($t) ?>">
                            <i class="<?= esc($icon) ?> mr-2 text-secondary"></i>
                            <span><?= ucfirst(esc($t)) ?></span>
                        </a>
                    </li>
                <?php endforeach; ?>
            <?php endif; ?>
        <?php endforeach; ?>
    <?php elseif (!empty($tables)): ?>
        <?php foreach ($tables as $t): ?>
            <?php
            $key = strtolower($t);
            $icon = isset($icons[$key]) && !empty($icons[$key]) ? $icons[$key] : 'fas fa-table';
            ?>
            <li class="nav-item">
                <a href="#"
                    class="nav-link table-link d-flex align-items-center <?= ($table ?? '') === $t ? 'active' : '' ?>"
                    data-table="<?= esc($t) ?>">
                    <i class="<?= esc($icon) ?> mr-2 text-secondary"></i>
                    <span><?= ucfirst(esc($t)) ?></span>
                </a>
            </li>
        <?php endforeach; ?>
    <?php else: ?>
        <li class="nav-item"><span class="text-muted ms-3">Tidak ada tabel</span></li>
    <?php endif; ?>
</ul>

<?= $this->endSection() ?>