$(function() {

  $(document).on('click', '.table-link', function(e) {
    e.preventDefault();
    const table = $(this).data('table');

    $('.table-link').removeClass('active');
    $(this).addClass('active');

    $('#crud-content').html('<div class="text-center p-5">Memuat data <b>' + table + '</b>...</div>');

    $.get(CRUD.baseUrl + '/crud/loadTableContent/' + table, function(html) {
      $('#crud-content').html(html);
      initDataTable(table); // ✅ tambahkan inisialisasi ulang DataTable
    });
  });

  // === Inisialisasi DataTable + event CRUD ===
  window.initDataTable = function(table) {
    const $table = $('#datatable');
    if (!$table.length) return;

    // ✅ Tambahan untuk mencegah error "Incorrect column count"
    const $theadCols = $table.find('thead th').length;
    const $tbody = $table.find('tbody');
    const $rows = $tbody.find('tr');
    if ($rows.length === 0) {
      // buat 1 baris kosong dengan jumlah kolom sesuai header
      let emptyRow = '<tr>';
      for (let i = 0; i < $theadCols; i++) {
        emptyRow += '<td></td>';
      }
      emptyRow += '</tr>';
      $tbody.html(emptyRow);
    }

    // Hancurkan DataTable sebelumnya (kalau ada), lalu buat baru
    const dt = $table.DataTable({
      destroy: true,
      pageLength: 10,
      language: { url: '//cdn.datatables.net/plug-ins/1.13.6/i18n/id.json' }
    });

    

    // === Simpan (Tambah/Edit) ===
    $(document).off('submit', '#crudForm').on('submit', '#crudForm', function(e) {
      e.preventDefault();
      const formData = $(this).serialize();

      $.post(CRUD.baseUrl + '/crud/save/' + table, formData, function(res) {
        if (res.status === 'success') {
          $('#formModal').modal('hide');
          Swal.fire({ icon: 'success', text: res.message, timer: 1000, showConfirmButton: false });

          // Reload tabel setelah simpan
          $.get(CRUD.baseUrl + '/crud/loadTableContent/' + table, function(html) {
            $('#crud-content').html(html);

            // Highlight baris baru / diupdate (jika last_id dikembalikan)
            if (res.last_id) {
              const row = $('#datatable tr[data-id="' + res.last_id + '"]');
              if (row.length) {
                row.addClass('highlight');
                setTimeout(() => row.removeClass('highlight'), 2000);
              }
            }

            initDataTable(table); // ✅ tambahkan di sini juga


          });
        } else {
          Swal.fire({ icon: 'error', text: res.message, timer: 2000, showConfirmButton: false });
        }
      }, 'json');
    });

    // === View (Detail) === 
    $(document).off('click', '.view-btn').on('click', '.view-btn', function() {
      const id = $(this).closest('tr').data('id');
      if (!id) {
        Swal.fire('Error', 'ID data tidak ditemukan.', 'error');
        return;
      }

      // === AJAX Request ===
      $.get(CRUD.baseUrl + '/crud/get/' + table + '/' + id, function(res) {
        // Swal.close(); // Tutup loading setelah response diterima

        if (res.status === 'success') {
          const data = res.data;
          let html = `
            <table class="table table-striped table-bordered">
              <tbody>
          `;

          for (const field in data) {
            // Escape HTML agar aman dari XSS
            const safeValue = $('<div>').text(data[field] ?? '-').html();

            html += `
              <tr>
                <th class="text-muted" style="width: 30%; text-transform: capitalize;">${field}</th>
                <td class="fw-bold">${safeValue}</td>
              </tr>
            `;
          }

          html += `
              </tbody>
            </table>
          `;

          $('#viewContent').html(html);
          $('#viewModal').modal('show');

        } else {
          Swal.fire('Gagal', res.message || 'Tidak dapat mengambil data.', 'error');
        }

      }, 'json')
      .fail(function() {
        // Swal.close();
        Swal.fire('Error', 'Terjadi kesalahan saat mengambil data dari server.', 'error');
      });
    });

    // === Tambah & Edit ===
    function generateFormFields(meta, data = {}) {
      const $tbody = $('#crudFormTable tbody');
      $tbody.empty();

      const pkCol = meta.find(c => c.key === 'PRI');
      if (pkCol) {
        $('#crudForm [name="' + pkCol.name + '"]').remove();
        $('#crudForm').prepend(`<input type="hidden" name="${pkCol.name}" value="${data[pkCol.name] || ''}">`);
      }

      meta.forEach(col => {
        if (col.key === 'PRI') return;
        const skipCols = ['created_at', 'updated_at', 'deleted_at', 'timestamp', 'created_by', 'updated_by'];
        if (skipCols.includes(col.name.toLowerCase())) return;

        const type = col.type.toLowerCase();
        const value = data[col.name] ?? '';
        let input = '';

        if (type.startsWith('enum') || type.startsWith('set')) {
          const options = type.match(/\((.*?)\)/)[1]
            .replace(/'/g, '')
            .split(',')
            .map(opt => opt.trim());
          input += `<select name="${col.name}" class="form-control">`;
          options.forEach(o => {
            const selected = (o === value) ? 'selected' : '';
            input += `<option value="${o}" ${selected}>${o}</option>`;
          });
          input += `</select>`;

        } else if (type.includes('date')) {
          input = `<input type="date" name="${col.name}" class="form-control" value="${value}">`;

        } else if (type.includes('int') || type.includes('decimal') || type.includes('float')) {
          input = `<input type="number" name="${col.name}" class="form-control" value="${value}">`;

        } else if (type.includes('text')) {
          input = `<textarea name="${col.name}" class="form-control" rows="3">${value}</textarea>`;

        } else {
          input = `<input type="text" name="${col.name}" class="form-control" value="${value}">`;
        }

        $tbody.append(`
          <tr>
            <td class="px-2 py-2" style="width:30%; font-weight:bold; color:#6c757d;">
              ${col.name}
            </td>
            <td class="px-2 py-2">
              ${input}
            </td>
          </tr>
        `);
      });
    }

    // === Tambah ===
    $(document).off('click', '.btn-add').on('click', '.btn-add', function() {
      $.get(CRUD.baseUrl + '/crud/structure/' + table, function(res) {
        if (res.status === 'success') {
          generateFormFields(res.meta); // kosongkan data (tambah)
          $('#formModal .modal-title').text('Tambah Data ' + table);
          $('#formModal').modal('show');
        } else {
          Swal.fire('Error', 'Gagal memuat struktur tabel.', 'error');
        }
      });
    });

    // === Edit ===
    $(document).off('click', '.edit-btn').on('click', '.edit-btn', function() {
      const id = $(this).closest('tr').data('id');
      if (!id) {
        Swal.fire('Error', 'ID data tidak ditemukan.', 'error');
        return;
      }

      $.when(
        $.get(CRUD.baseUrl + '/crud/structure/' + table),
        $.get(CRUD.baseUrl + '/crud/get/' + table + '/' + id)
      ).done(function(structRes, dataRes) {
        const struct = structRes[0];
        const rowRes = dataRes[0];

        if (struct.status === 'success' && rowRes.status === 'success') {
          generateFormFields(struct.meta, rowRes.data); // isi data
          $('#formModal .modal-title').text('Edit Data ' + table);
          $('#formModal').modal('show');
        } else {
          Swal.fire('Error', 'Gagal memuat struktur atau data.', 'error');
        }
      });
    });

    // === Hapus ===
    $(document).off('click', '.delete-btn').on('click', '.delete-btn', function() {
      const id = $(this).closest('tr').data('id');
      Swal.fire({
        title: 'Yakin hapus data ini?',
        text: 'Data yang dihapus tidak bisa dikembalikan!',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Ya, hapus',
        cancelButtonText: 'Batal'
      }).then(result => {
        if (result.isConfirmed) {
          $.post(CRUD.baseUrl + '/crud/delete/' + table + '/' + id, function(res) {
            if (res.status === 'success') {
              Swal.fire({ icon: 'success', title: res.message, timer: 1500, showConfirmButton: false });
              $.get(CRUD.baseUrl + '/crud/loadTableContent/' + table, function(html) {
                $('#crud-content').html(html);
                initDataTable(table); // ✅ tambahkan agar tabel aktif lagi
              });
            } else {
              Swal.fire({ icon: 'error', title: res.message, timer: 2000, showConfirmButton: false });
            }
          }, 'json');
        }
      });
    });

    // === Hapus Semua Data ===
$(document).off('click', '.btn-delete-all').on('click', '.btn-delete-all', function() {
  const table = $(this).data('table');

  Swal.fire({
    title: 'Yakin hapus semua data?',
    text: 'Semua data di tabel ini akan dihapus permanen!',
    icon: 'warning',
    showCancelButton: true,
    confirmButtonText: 'Ya, hapus semua',
    cancelButtonText: 'Batal'
  }).then(result => {
    if (result.isConfirmed) {
      $.post(CRUD.baseUrl + '/crud/deleteAll/' + table, function(res) {
        if (res.status === 'success') {
          Swal.fire({ icon: 'success', title: res.message, timer: 1500, showConfirmButton: false });
          $.get(CRUD.baseUrl + '/crud/loadTableContent/' + table, function(html) {
            $('#crud-content').html(html);
            initDataTable(table); // ✅ re-inisialisasi tabel agar aktif kembali
          });
        } else {
          Swal.fire({ icon: 'error', title: res.message, timer: 2000, showConfirmButton: false });
        }
      }, 'json');
    }
  });
});

    // === Export ===
    $(document).off('click', '.btn-export').on('click', '.btn-export', function() {
      window.location.href = CRUD.baseUrl + '/crud/export/' + table;
    });

    // === Import ===
    $(document).off('click', '.btn-import').on('click', '.btn-import', function() {
      $('#importModal').modal('show');
    });

    $(document).off('submit', '#importForm').on('submit', '#importForm', function(e) {
      e.preventDefault();
      const formData = new FormData(this);

      Swal.fire({
        title: 'Mengupload data...',
        text: 'Mohon tunggu sebentar',
        allowOutsideClick: false,
        didOpen: () => Swal.showLoading()
      });

      $.ajax({
        url: CRUD.baseUrl + '/crud/import/' + table,
        type: 'POST',
        data: formData,
        contentType: false,
        processData: false,
        success: function(res) {
          Swal.close();
          if (res.status === 'success') {
            $('#importModal').modal('hide');
            Swal.fire({
              icon: 'success',
              title: 'Berhasil!',
              html: `<b>${res.inserted}</b> data baru ditambahkan<br><b>${res.updated}</b> data diperbarui.`,
              text: res.message,
              timer: 2000,
              showConfirmButton: false
            }).then(() => {
              $.get(CRUD.baseUrl + '/crud/loadTableContent/' + table, function(html) {
                $('#crud-content').html(html);
                initDataTable(table); // ✅ dan di sini juga

                // Highlight baris baru jika backend kirim daftar ID baru
                if (res.inserted_ids) {
                  res.inserted_ids.forEach(id => {
                    const row = $('#datatable tr[data-id="'+id+'"]');
                    row.addClass('highlight');
                    setTimeout(() => row.removeClass('highlight'), 3000);
                  });
                }
              });
            });
          } else {
            Swal.fire({ icon: 'error', title: 'Gagal', text: res.message });
          }
        },
        error: function() {
          Swal.close();
          Swal.fire({ icon: 'error', title: 'Error', text: 'Gagal mengunggah file.' });
        }
      });
    });
  }; // Penutup untuk initDataTable

}); // Penutup untuk $(function()

function reloadTable(table) {
  $('#crud-content').html('<div class="text-center p-4">Memuat ulang data...</div>');
  $.get(CRUD.baseUrl + '/crud/loadTableContent/' + table, function(html) {
    $('#crud-content').html(html);
    initDataTable(table); // ✅ tetap disini juga
  });
}

// Reset form ke mode normal setelah modal ditutup
$('#formModal').on('hidden.bs.modal', function() {
  $('#crudForm input, #crudForm select, #crudForm textarea').prop('readonly', false).prop('disabled', false);
  $('#crudForm button[type=submit]').show();
});

// === Print Table ===
$(document).off('click', '.btn-print').on('click', '.btn-print', function() {
    // Ambil tabel utama — bisa sesuaikan ID-nya kalau perlu
    const tableContent = document.querySelector('table');
    if (!tableContent) {
        Swal.fire('Oops', 'Tabel data tidak ditemukan!', 'warning');
        return;
    }

    // Ambil judul tabel (biasanya di h4)
    const titleElement = document.querySelector('h4');
    const titleText = titleElement ? titleElement.innerText : 'Data Tabel';

    // Kloning tabel agar tidak mengubah tampilan asli di halaman
    const clonedTable = tableContent.cloneNode(true);

    // === Hapus kolom aksi (biasanya berisi tombol Edit/Delete) ===
    // Cari kolom yang punya tombol aksi berdasarkan class atau tombol di dalamnya
    clonedTable.querySelectorAll('th, td').forEach(cell => {
        if (
            cell.querySelector('.btn') || // ada tombol
            /aksi|action/i.test(cell.innerText.trim()) // ada teks "Aksi" atau "Action"
        ) {
            const cellIndex = cell.cellIndex;
            // Hapus kolom tersebut dari semua baris
            clonedTable.querySelectorAll('tr').forEach(row => {
                if (row.cells[cellIndex]) row.deleteCell(cellIndex);
            });
        }
    });

    // Buka jendela cetak baru
    const printWindow = window.open('', '', 'width=1000,height=700');
    printWindow.document.write(`
        <html>
            <head>
                <title>${titleText}</title>
                <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
                <style>
                    body { padding: 20px; font-size: 14px; color: #000; }
                    table { width: 100%; border-collapse: collapse; margin-top: 10px; }
                    th, td { border: 1px solid #999; padding: 8px; text-align: left; }
                    th { background-color: #f8f9fa; }
                    h4 { margin-bottom: 20px; text-align: center; }
                    @media print {
                        @page { margin: 20mm; }
                    }
                </style>
            </head>
            <body>
                <h4>${titleText}</h4>
                ${clonedTable.outerHTML}
                <script>window.onload = function(){ window.print(); }</script>
            </body>
        </html>
    `);
    printWindow.document.close();
});

// toggle status
$(document).on('change', '.toggle-status', function() {
    const table  = $(this).data('table');
    const column = $(this).data('column');
    const id     = $(this).data('field'); // atau primary key sesuai kebutuhan
    const status = $(this).is(':checked') ? 'aktif' : 'nonaktif';

    $.post(CRUD.baseUrl + '/crud/updateToggle', { table, column, id, status }, function(res) {
        if (res.status === 'success') {
            // Swal.fire({
            //     icon: 'success',
            //     title: 'Berhasil',
            //     text: res.message,
            //     timer: 1000,
            //     showConfirmButton: false
            // });
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Gagal',
                text: res.message || 'Terjadi kesalahan saat menyimpan data.',
                timer: 2000,
                showConfirmButton: false
            });
        }
    }, 'json').fail(function() {
        Swal.fire({
            icon: 'error',
            title: 'Gagal',
            text: 'Tidak dapat terhubung ke server.',
            timer: 2000,
            showConfirmButton: false
        });
    });
});

$(document).ready(function() {
    // Event click toggle
    $(document).on('change', '.toggle-status', function() {
        const $input = $(this);
        const table = $input.data('table');
        const rowId = $input.data('field');    // ID baris
        const column = $input.data('column');  // nama kolom
        const status = $input.is(':checked') ? 'aktif' : 'nonaktif';

        // Tampilkan loading kecil di toggle (opsional)
        $input.prop('disabled', true);

        $.ajax({
            url: CRUD.baseUrl + '/crud/updateToggle', // endpoint baru di controller
            type: 'POST',
            data: {
                table: table,
                id: rowId,
                column: column,
                status: status
            },
            dataType: 'json',
            success: function(res) {
                if (res.status === 'success') {

                    // sukses, bisa kasih notif kecil (opsional)
                    $input.prop('disabled', false);
                  //  reloadTable(table); // coba ditambah ini
                } else {
                    Swal.fire('Gagal', res.message || 'Tidak dapat mengubah status.', 'error');
                    $input.prop('checked', ! $input.is(':checked')); // kembalikan toggle
                    $input.prop('disabled', false);
                }
            },
            error: function() {
                Swal.fire('Error', 'Terjadi kesalahan saat mengupdate.', 'error');
                $input.prop('checked', ! $input.is(':checked')); // kembalikan toggle
                $input.prop('disabled', false);
            }
        });
    });
});

// === Generate ===
$(document).off('click', '.btn-generate').on('click', '.btn-generate', function() {
  const table = $(this).data('table'); // ✅ fix: ambil nama tabel
  if (!table) {
    console.error('Nama tabel tidak ditemukan di tombol.');
    Swal.fire('Error', 'Nama tabel tidak ditemukan.', 'error');
    return;
  }

  console.log('Generate button clicked for table:', table);

  Swal.fire({
    title: 'Generate Data?',
    text: 'Data otomatis akan dibuat untuk tabel: ' + table,
    icon: 'question',
    showCancelButton: true,
    confirmButtonText: 'Ya, lanjutkan',
    cancelButtonText: 'Batal'
  }).then(result => {
    if (!result.isConfirmed) return;

    Swal.fire({
      title: 'Memproses...',
      text: 'Sedang mengisi data otomatis, mohon tunggu...',
      allowOutsideClick: false,
      didOpen: () => Swal.showLoading()
    });

    $.ajax({
      url: CRUD.baseUrl + '/crud/generate/' + table,
      type: 'GET',
      dataType: 'json',
      success: function(res) {
        Swal.close();
        console.log('Generate result:', res);

        if (res.status === 'success') {
          Swal.fire({
            icon: 'success',
            title: 'Berhasil!',
            html: res.message || 'Generate selesai.',
            timer: 2000,
            showConfirmButton: false
          });
          reloadTable(table);
        } else {
          Swal.fire('Gagal', res.message || 'Terjadi kesalahan saat generate.', 'error');
        }
      },
      error: function(xhr) {
        Swal.close();
        console.error('AJAX Error:', xhr.responseText);
        Swal.fire('Error', 'Tidak dapat menghubungi server (' + xhr.status + ')', 'error');
      }
    });
  });
});